*** COS 2019 08, Marginsplot last update 2023 03  
           
           
           
program define dq_acc_mp1  
           
syntax varlist (max=1 numeric) [if] [in], clustervar(varname numeric) [controlvars(varlist numeric) minclustersize(int 1) doubledisplay (int 0)] 		///  
			[warncolor(string) ststrata(string) stcluster(string) gd(string) decimals(int 2) cilevel(int 95)  indent(int 0) forcecalc(int 1)]  
marksample touse, novarlist  
           
if `indent'>0 local indent=`indent'+5							  
local adoname "dq_acc_mp1"  
local text_i "di as text _n "  					  
`text_i' "     Marginal effects for variable `varlist' with cluster `clustervar'"  
if "`controlvars'"~="" `text_i' "with control variables `controlvars'" _n  
           
local structure "`ststrata'_`stcluster'"  
local pointer "$`varlist'"														  
	          
	          
local graph_path "`gd'mp1_`structure'_`varlist'.png"  
scalar graph_mp1_`ststrata'_`pointer'="`graph_path'"  
           
	          
	          
           
           
capture confirm file "`graph_path'"  
           
if _rc>0 | `forcecalc'~=0  {									  
           
           
	          
	tempvar constvar0 constvar1 constvar2 constvar3 		  
           
	* Help indicator- variable with valid observations on all outcome variable observations (0) /and on cluster variable observations (1)  
	qui gen `constvar0'=1			if `touse' &  `varlist'<.  
	qui gen `constvar1'=1			if `touse' &  `varlist'<. & `clustervar'<.  
	if "`controlvars'"~="" {  
		tempvar rowmiss_cv  
		qui egen `rowmiss_cv' = rowmiss(`controlvars')  
		qui gen `constvar2'=1		if `touse' &  `varlist'<.  & `rowmiss_cv'==0  
	}	        
	if "`controlvars'"=="" {  
		qui gen `constvar2'=`constvar1'  
	}         
	          
	qui count if  `constvar0'==1  
	local alln=r(N)  
	          
	if `alln'<`minclustersize' & `indent'>0 {  
		dq_out_etg , text("Too few observations in outcome variable `varlist': N=`alln'") savename("`graph_path'")    indent(`indent')  
		exit     
	}	        
	          
	qui count if  `constvar1'==1  
	local cl1n=r(N)  
	local localmis1 =`alln'-`cl1n'  
	qui count if  `constvar2'==1  
	local cl2n=r(N)  
	local localmis2 =`cl1n'-`cl2n'  
	          
	tempvar clsize																				  
	bysort `clustervar': egen `clsize' = total(`constvar2')  		  							  
	qui gen `constvar3' = 1 if `clsize' >=`minclustersize' & `constvar2'==1 & `constvar1'==1	  
	qui count if  `constvar3'==1  
	local analysissize=r(N)  
		         
	qui levelsof `clustervar' if `constvar3'==. & `clsize' <`minclustersize'  
	local clexcluded "`r(levels)'"  
		         
	preserve  
	qui drop if `constvar3'==.  
	          
	          
	qui levelsof `clustervar' if `constvar3'==1															  
	local clusterlevels "`r(levels)'"  
	local clustern =r(r)  
	          
	local clusternumber=wordcount("`r(levels)'")															  
           
	if `clusternumber'==0  & `indent'>0 {  
		dq_out_etg , text("Insufficient observations in variable `varlist', resulting in  no available cluster with sufficient observations") savename("`graph_path'")   indent(`indent')  
		exit     
	}         
           
	if `clusternumber'==1  & `indent'>0 {  
		dq_out_etg , text("Only one cluster with variable `varlist'. Display not useful.") savename("`graph_path'")   indent(`indent')  
		exit     
	}         
	 	        
	qui levelsof `varlist' if `constvar3'==1  
	local outcomelevels=wordcount("`r(levels)'")  
	          
	if `outcomelevels'<=1 {  
		dq_out_etg , text("No variance in outcome variable `varlist'") savename("`graph_path'")    indent(`indent')  
		exit							  
	}	        
	          
	          
	if "`clexcluded'"~="" 							local notetext "N=`analysissize' out of `alln';  Omitted clusters with n<`minclustersize': `clexcluded'"				  
	if "`clexcluded'"~="" & `analysissize'== `alln' local notetext "N=`analysissize' out of `alln'"			  
	if  `analysissize'== `alln' 					local notetext "N=`analysissize'" 	  
	capture confirm scalar icc1_fe_`structure'_`pointer'  
	if _rc==0 {  
		dq_hlp_std ,  numstring("`= icc1_fe_`structure'_`pointer''") decimals(`decimals')  indent(`indent')		  
		local notetext "`notetext' ; $Varianceproportion_2 `r(numstring)'"  
	}         
	          
	local controlvars=trim("`controlvars'")  
	local ylab1_n ""  
	local ylab2_n ""  
	local captiontext ""									  
	local minevent 3										  
	local sdfactor 0.5										  
           
	local graph_control  ""  
	local graph_nocontrol ""  
	local lowersdline ""  
	local uppersdline ""  
	local sdlinecomment ""  
	          
	if `doubledisplay'==0 {  
		local color0 "edkblue"								  
		local color1 "edkblue"								  
	}         
	if `doubledisplay'==1 {  
		local color0 "emidblue%25"							  
		local color1 "edkblue"								  
	}	        
           
	local offset0=0											  
	local offset1=0.15*`doubledisplay'						  
	local graph0 graph_nocontrol							  
	local graph1 graph_control								  
	local clshortname = substr("`clustervar'",1,9)			  
	          
	if "`warncolor'"=="" local warncolor "red"	  
	          
	dq_hlp_fmt, clusternumber(`clusternumber')  indent(`indent')  
	local textsize_y		=`r(textsize_y)'  
	local textsize_x		=`r(textsize_x)'  
	local textlegendsize	=`r(textlegendsize)'  
	local gheight 			"`r(gheight)'"  
	local gwidth 			"`r(gwidth)'"  
	local labmarkersize 	"`r(labmarkersize)'"  
	local mlabposition		=`r(mlabposition)'	  
		 	       
	if `localmis1'>0 					local mp1_misstext1 `"cluster variable, N miss=`localmis1'"'  
	if `localmis2'>0 					local mp1_misstext2 `"control variables, N miss=`localmis2'"'  
	if `localmis1'>0 | `localmis2'>0 	local captiontext 	`"caption("Warning: Missing observations due to `mp1_misstext1'  `mp1_misstext2'", size(`textlegendsize') color(`warncolor'))"'	  
           
	tempvar clustercount			  
	qui gen `clustercount'= "  "										  
	tempvar clusterlevel  
	qui gen `clusterlevel'=.											  
           
	local n=0															  
	foreach level of numlist `clusterlevels' {  
		local n=`n'+1  
		         
		qui count if `clustervar'==`level' & `constvar3'==1				  
		local Nlevel_`n'=r(N)											  
		local ylab1_n =`"`ylab1_n' `n' "`level'" "'						  
		local ylab2_n =`"`ylab2_n' `n' "n=`Nlevel_`n''" "'				  
		         
		if `doubledisplay'==0 local line=`n'							  
		if `doubledisplay'==1 local line =2*`n'							  
		qui replace `clustercount'="n=`Nlevel_`n''"  in `line'				  
		         
		qui levelsof `varlist' if `constvar3'==1 & `clustervar'==`level'  
		local Outcomelevels_`level'=wordcount("`r(levels)'")			  
	}         
	*list `clustercount' in 1/30  
           
	local areaend = `n'+1  
	          
	if `outcomelevels'==2 {  
	          
		qui prop `varlist' if `touse'  
		mat def eb=e(b)  
		local casecount0 = trunc(eb[1,1]*e(df_r))	  
		local casecount1 = trunc(eb[1,2]*e(df_r))  
		local mincasecount =min(`casecount0',`casecount1')  
		if  `mincasecount'  <`minevent' {  
			local events =min(`casecount0', `casecount1')  
			dq_out_etg , text("Too little variance in outcome variable `varlist': N events=`mincasecount'") ///  
									savename("`graph_path'")    indent(`indent')  
			exit			  
		}        
           
		local regtype="logit"					  
		local iteratesteps "iterate(100)"  
		local decimals =3  
	}         
	          
	          
	if `outcomelevels'>2  {  
		local regtype="reg"						  
		local iteratesteps ""  
	}         
           
	          
		         
	local controlvarlist="" 	  
	if "`controlvars'"~="" {  
		dq_hlp_cov `controlvars' if `touse',  indent(`indent')  
		local controlvarlist="`r(controlvarlist)'"  
	}         
	          
	qui tab(`clustervar'), gen(___CVar_)  
	          
	          
	*** Without (n=0) and with (n=1) adjustment  
           
	local n=0																  
	if `doubledisplay'==0 & "`controlvarlist'"~="" local n=1 				  
	local cvars0 ""															  
	local cvars1 "`controlvarlist'"											  
	local regcomment0 ""						  
	local regcomment1 " with centered control variables `controlvars' "		  
	*Loop over calcualtion with and without ontrol variables  
	while `n'<2 {  
		`text_i' "Regression`regcomment`n'': `regtype' `varlist' i.`clustervar' `cvars`n'' if `constvar3'==1, noomit noconstant `iteratesteps'" _n  
		xi, noomit: `regtype' `varlist' ___CVar_* `cvars`n'' if `constvar3'==1,  noomit  noconstant `iteratesteps'  level(`cilevel')  
		*`regtype' `varlist'  i.`clustervar' `cvars`n'' if `constvar3'==1,  noomit   `iteratesteps'  
		estimates store A`n'	  
		mat def eB`n' =e(b)										  
		*mat list  eB`n'  
		*estimates dir A`n'	  
           
		qui margins  
		mat def marginsmat=r(table)  
		local meanline 			= marginsmat[1,1]  
		local lowerconflimit 	= marginsmat[5,1]		  
		local upperconflimit 	= marginsmat[6,1]	  
		dq_hlp_std ,  numstring("`meanline'") decimals(`decimals')  indent(`indent')	  
		local trimmedmeannumber  "`r(numstring)'"				  
		         
		local markercolor="`color`n''"  
		local markerlabelcolor="`color`n''"		  
           
		qui sum `varlist' if `constvar3'==1  
		local lowersd= `meanline'- `sdfactor'*r(sd)  
		local uppersd= `meanline'+ `sdfactor'*r(sd)		  
	          
		         
		local m=0															  
		foreach level of numlist `clusterlevels'  {							  
			local m=`m'+1													  
		         
			if `clusternumber'<=25 & `indent'>0  local markercolor="${color`level'}"  
			if `clusternumber'<=25 & `indent'>0  local markerlabelcolor="${color`level'}"  
			 			    
			        
			qui sum `varlist' if `constvar3'==1 & ___CVar_`m'==1  
			local rmean=r(mean)  
			        
			*Generate the matrix for each level of the predictor  
			if eB`n'[1,`m']~=0  | "`regtype'"=="reg" 	{  
			        
				local marginscheck ""  
				forvalues o=1/`clustern' {  
				    if `o'==`m' local marginscheck=trim("`marginscheck' ___CVar_`o'==1")		//On the diagonal set 0  
				    if `o'~=`m' local marginscheck=trim("`marginscheck' ___CVar_`o'==0")		//Outside the diagonal set 0  
				}      
				       
				qui estimates restore A`n'  
				qui margins,  at(`marginscheck') post  
				mat def clustermat`m'=r(table)  
				est store clustereffect`m'  
				*est dir clustereffect`m'  
				       
				local c1 = clustermat`m'[1,1]  
				local c2 = clustermat`m'[5,1]  
				local c3 = clustermat`m'[6,1]  
				       
				matrix cm`m' = J(1, 3, .)  
				mat input cm`m'=(`c1',`c2',`c3')  
				matrix rown cm`m' = `level'			  
			}       
           
			if eB`n'[1,`m']==0 & `Outcomelevels_`level''==2 & "`regtype'"=="logit" 	{  
			    matrix cm`m' = J(1, 3, .)  
				mat input cm`m'=(0,0,0)  
				matrix rown cm`m' = `level'  
			}	      
			        
			if eB`n'[1,`m']==0 & `rmean'==0 & "`regtype'"=="logit" 	{  
			    matrix cm`m' = J(1, 3, .)  
				mat input cm`m'=(0,0,0)  
				matrix rown cm`m' = `level'  
			}	      
			if eB`n'[1,`m']==0 & `rmean'==1   & "`regtype'"=="logit"  	{  
			    matrix cm`m' = J(1, 3, .)  
				mat input cm`m'=(1,1,1)  
				matrix rown cm`m' = `level'  
			}	      
           
			local `graph`n'' `"``graph`n'''  (matrix(cm`m'[,1]), ci((cm`m'[,2] cm`m'[,3])) mcolor(`markercolor') ciopts(color(`color`n'' `color`n'')) msymbol(d) msize(`labmarkersize') offset(`offset`n'') mlabel(`clustercount') mlabposition(`mlabposition') mlabcolor(`markerlabelcolor') 	mlabsize(`labmarkersize') ) "'  
           
		}        
           
		if "`controlvars'"~="" local n=`n'+1  
			else local n=2		  
           
	}         
	          
	if "`controlvars'"~=""  local notetext2 `"$vt_4: `controlvars'"'							  
		         
	if `doubledisplay'==0	local captiontext `"caption("`notetext2'"												, size(`textlegendsize'))"'			  
	if `doubledisplay'==1	local captiontext `"caption("`notetext2'; Upper line: adjusted; Lower line: unadjusted"	, size(`textlegendsize'))"'			  
	local notetext `"note("`notetext' ", size(`textlegendsize'))"'								  
	local legendstyle "legend(off subtitle("Legend"))"  
	*local legendstyle "legend(order(3 "No adjustment" 6 "With adjustment") region(lstyle(none)) rows(1) )"  
           
		         
	          
	if "`regtype'"=="reg" {  
		local lowersdline `"scatteri 0 `lowersd' `areaend' `lowersd' , recast(connect) msymbol(o) mcolor(gs4%01) color(gs4%20) || "'  
		local uppersdline `"scatteri 0 `uppersd' `areaend' `uppersd' , recast(connect) msymbol(o) mcolor(gs4%01) color(gs4%20) || "'  
		local sdlinecomment `"text(`areaend' `lowersd' "M-`sdfactor'SD", place(nw) color(gs14) size(`textsize_x') orientation(vertical)) text(`areaend' `uppersd' "M+`sdfactor'SD", place(ne) color(gs14) size(`textsize_x') orientation(vertical)) "'  
		if  "`controlvarlist'"==""  local meanlinetext `"text(0 `meanline' "$Mean_1 $unadjusted_1: `trimmedmeannumber'", place(n) color(gs9) size(`textsize_x') orientation(horizontal)) "'	  
		if  "`controlvarlist'"~=""  local meanlinetext `"text(0 `meanline' "$Mean_1 $adjusted_1: `trimmedmeannumber'", place(n) color(gs9) size(`textsize_x') orientation(horizontal)) "'	  
		local xtitletext ""  
	}         
	          
	if "`regtype'"=="logit" {  
		if  "`controlvarlist'"==""  local meanlinetext `"text(0 `meanline' "$Proportion_1 $unadjusted_1: `trimmedmeannumber'", place(n) color(gs9) size(`textsize_x') orientation(horizontal)) "'	  
		if  "`controlvarlist'"~=""  local meanlinetext `"text(0 `meanline' "$Proportion_1 $adjusted_1 : `trimmedmeannumber'", place(n) color(gs9) size(`textsize_x') orientation(horizontal)) "'	  
		local xtitletext "p"  
	}         
		         
		         
	*** Note: pstyle must be used for graphs with differnt components because afterise at 16+ elements an error meaasge occurrs https://www.stata.com/manuals13/g-4pstyle.pdf  
           
	coefplot  `graph_nocontrol'  `graph_control',	pstyle(p1)																											///  
		     	drop(_cons  `controlvarlist')   msym(s) mfcolor(white)  ciopts(lwidth(*1 *2))  																			///  
				addplot( scatteri 0 `lowerconflimit' `areaend' `lowerconflimit' `areaend' `upperconflimit'  1 `upperconflimit'  ,  recast(area)  color(gs4%20)	||  	///  
				scatteri 0 `meanline' `areaend' `meanline' , recast(connect) msymbol(o) mcolor(gs4%01) color(edkblue%50) lwidth(.5) ||  `lowersdline' `uppersdline' )  	///  
				xline(`meanline', lwidth(0.5) lcolor(gs12))  `sdlinecomment' `meanlinetext' `legendstyle'	 															///  
				xlabel(, nogrid  						labsize(`textsize_x'))	xlabel(#8)	 xmtick(#16)				 												///  
				ylabel(`ylab1_n', 	angle(horizontal)   labsize(`textsize_y') gstyle(dot) )  	grid(none)   												 			///  
				xtitle ("`xtitletext'", size(`textlegendsize')) 																	 									///  
				title("") 																														 						///  
				`notetext' `captiontext'																																///  
				graphregion(fcolor(white) margin(medium))	 		 		  
           
	if `indent'>0  qui graph export "`graph_path'", replace width(`gwidth') height(`gheight')  
	restore   
	          
}	         
           
           
end        
           
